/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CALIBRATIONGETRAWCOORDINATECOMMAND_H_
#define _CALIBRATIONGETRAWCOORDINATECOMMAND_H_

#include <string>

#include "ICommand.h"
#include "CalibrationTypes.h"

class CalibrationGetRawCoordinateCommand : public ICommand
{
public:
    /*!
     * \action    This command converts a logical coordinate to a raw
     * given a subdivision and input device, according to the device
     * calibration.
     * \frequency
     * \param[in] sender          Process id of application that sent this
     *                            command
     * \param[in] deviceName      Name of the input device
     * \param[in] subdivisionName The name of the subdivision to check in
     * \param[in] logical         The logical coordinate to convert to raw
     * \param[in] raw             Location to return the raw coordinate
     * \ingroup Commands
     */
    CalibrationGetRawCoordinateCommand(pid_t sender,
        std::string& deviceName, std::string& subdivisionName,
        LayerManagerCalibration::coordinate* logical,
        LayerManagerCalibration::coordinate* raw)
    : ICommand(ExecuteSynchronous, sender)
    , m_deviceName(deviceName)
    , m_subdivisionName(subdivisionName)
    , m_logical(logical)
    , m_raw(raw)
    {}

    /**
     * \brief default destructor
     */
    virtual ~CalibrationGetRawCoordinateCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement Commands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionFailed: execution failed
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    std::string m_deviceName;
    std::string m_subdivisionName;
    LayerManagerCalibration::coordinate* m_logical;
    LayerManagerCalibration::coordinate* m_raw;

};

#endif // _CALIBRATIONGETRAWCOORDINATECOMMAND_H_
